
import topology.basic
import topology.compact_open
import data.nat.prime
import data.real.basic
import data.real.irrational
import data.complex.basic
import data.fin.basic
import geometry.euclidean.basic
import analysis.inner_product_space.pi_L2
import algebra.group.defs
import algebra.field.basic
import combinatorics.configuration
import ring_theory.polynomial.basic
import group_theory.free_group
import combinatorics.simple_graph.basic
import ring_theory.integral_closure
import data.fintype.card
import category_theory.category.basic
import ring_theory.discrete_valuation_ring
import group_theory.torsion
import linear_algebra.matrix.charpoly.basic
import algebra.order.absolute_value
import analysis.convex.basic
import topology.uniform_space.uniform_convergence_topology
import topology.sequences
import analysis.normed.group.infinite_sum
import data.nat.choose.sum
import group_theory.specific_groups.cyclic
import group_theory.order_of_element
import analysis.mean_inequalities
import analysis.normed_space.banach
import topology.algebra.continuous_monoid_hom
import linear_algebra.matrix.symmetric
import analysis.inner_product_space.spectrum
import ring_theory.class_group
import ring_theory.dedekind_domain.basic
import ring_theory.principal_ideal_domain
import model_theory.satisfiability
import probability.integration
import ring_theory.simple_module
import category_theory.preadditive.schur
import representation_theory.maschke
import topology.paracompact
import combinatorics.simple_graph.coloring
/- FEW SHOT PROMPTS TO CODEX(START)
/--`theorem`
Power Set is Closed under Intersection
Let $S$ be a set.

Let $\powerset S$ be the power set of $S$.


Then:
:$\forall A, B \in \powerset S: A \cap B \in \powerset S$
`proof`
Let $A, B \in \powerset S$.

Then by the definition of power set, $A \subseteq S$ and $B \subseteq S$.

From Intersection is Subset we have that $A \cap B \subseteq A$.

It follows from Subset Relation is Transitive that $A \cap B \subseteq S$.

Thus $A \cap B \in \powerset S$ and closure is proved.
{{qed}}
-/
theorem power_set_intersection_closed {α : Type*} (S : set α) : ∀ A B ∈ 𝒫 S, (A ∩ B) ∈ 𝒫 S :=
begin
  assume (A : set α) (hA : A ∈ 𝒫 S) (B : set α) (hB : B ∈ 𝒫 S),
  have h1 : (A ⊆ S) ∧ (B ⊆ S), from by auto [set.subset_of_mem_powerset, set.subset_of_mem_powerset],
  have h2 : (A ∩ B) ⊆ A, from by auto [set.inter_subset_left],
  have h3 : (A ∩ B) ⊆ S, from by auto [set.subset.trans],
  show (A ∩ B) ∈  𝒫 S, from by auto [set.mem_powerset],
end

/--`theorem`
Square of Sum
 :$\forall x, y \in \R: \paren {x + y}^2 = x^2 + 2 x y + y^2$
`proof`
Follows from the distribution of multiplication over addition:

{{begin-eqn}}
{{eqn | l = \left({x + y}\right)^2
      | r = \left({x + y}\right) \cdot \left({x + y}\right)
}}
{{eqn | r = x \cdot \left({x + y}\right) + y \cdot \left({x + y}\right)
      | c = Real Multiplication Distributes over Addition
}}
{{eqn | r = x \cdot x + x \cdot y + y \cdot x + y \cdot y
      | c = Real Multiplication Distributes over Addition
}}
{{eqn | r = x^2 + 2xy + y^2
      | c = 
}}
{{end-eqn}}
{{qed}}
-/
theorem square_of_sum (x y : ℝ) : (x + y)^2 = (x^2 + 2*x*y + y^2)
begin
  calc (x + y)^2 = (x+y)*(x+y) : by auto [sq]
  ... = x*(x+y) + y*(x+y) : by auto [add_mul]
  ... = x*x + x*y + y*x + y*y : by auto [mul_comm, add_mul] using [ring]
  ... = x^2 + 2*x*y + y^2 : by auto [sq, mul_comm] using [ring]
end

/--`theorem`
Identity of Group is Unique
Let $\struct {G, \circ}$ be a group. Then there is a unique identity element $e \in G$.
`proof`
From Group has Latin Square Property, there exists a unique $x \in G$ such that:
:$a x = b$

and there exists a unique $y \in G$ such that:
:$y a = b$

Setting $b = a$, this becomes:

There exists a unique $x \in G$ such that:
:$a x = a$

and there exists a unique $y \in G$ such that:
:$y a = a$

These $x$ and $y$ are both $e$, by definition of identity element.
{{qed}}
-/
theorem group_identity_unique {G : Type*} [group G] : ∃! e : G, ∀ a : G, e * a = a ∧ a * e = a :=
begin
  have h1 : ∀ a b : G, ∃! x : G, a * x = b, from by auto using [use (a⁻¹ * b)],
  have h2 : ∀ a b : G, ∃! y : G, y * a = b, from by auto using [use b * a⁻¹], 

  have h3 : ∀ a : G, ∃! x : G, a * x = a, from by auto [h1],
  have h4 : ∀ a : G, ∃! y : G, y * a = a, from by auto [h2],

  have h5 : ∀ a : G, classical.some (h3 a).exists = (1 : G), from by auto [exists_unique.unique, h3, classical.some_spec, exists_unique.exists, mul_one],
  have h6 : ∀ a : G, classical.some (h4 a).exists = (1 : G), from by auto [exists_unique.unique, h4, classical.some_spec, exists_unique.exists, one_mul],

  show ∃! e : G, ∀ a : G, e * a = a ∧ a * e = a, from by auto [h3, h4, exists_unique.unique, classical.some_spec, exists_unique.exists] using [use (1 : G)],
end

/--`theorem`
Absolute Value Function is Convex
Let $f: \R \to \R$ be the absolute value function on the real numbers.

Then $f$ is convex.
`proof`
Let $x, y \in \R$.

Let $\alpha, \beta \in \R_{\ge 0}$ where $\alpha + \beta = 1$.

{{begin-eqn}}
{{eqn | l = \map f {\alpha x + \beta y}
      | r = \size {\alpha x + \beta y}
      | c = Definition of $f$
}}
{{eqn | o = \le
      | r = \size {\alpha x} + \size {\beta y}
      | c = Triangle Inequality for Real Numbers
}}
{{eqn | r = \size \alpha \size x + \size \beta \size y
      | c = Absolute Value of Product
}}
{{eqn | r = \alpha \size x + \beta \size y
      | c = {{Defof|Absolute Value}}
}}
{{eqn | r = \alpha \, \map f x + \beta \, \map f y
      | c = Definition of $f$
}}
{{end-eqn}}

Hence the result by definition of Convex Real Function.
{{qed}}
-/
theorem  absolute_value_function_convex : convex_on ℝ (@set.univ ℝ) abs :=

FEW SHOT PROMPTS TO CODEX(END)-/
--OUTPUT 1
theorem begin
  assume x y : ℝ,
  assume α β : ℝ,
  assume h1 : α ≥ 0,
  assume h2 : β ≥ 0,
  assume h3 : α + β = 1,
  calc abs (α*x + β*y) ≤ abs (α*x) + abs (β*y) : by auto [abs_add]
  ... = abs α * abs x + abs β * abs y : by auto [abs_mul]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*abs x + β*abs y : by auto [abs]
  ... = α*
end --Needs more than 2000 tokens!

--OUTPUT 2
theorem begin
  assume x y : ℝ,
  assume (α : ℝ) (hα : 0 ≤ α) (β : ℝ) (hβ : 0 ≤ β) (h1 : α + β = 1),

  calc abs (α*x + β*y) = abs (α*x + β*y) : by auto [abs]
  ... ≤ abs (α*x) + abs (β*y) : by auto [abs, add_le_add] using [triangle]
  ... = abs α * abs x + abs β * abs y : by auto [abs, add_mul]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs y : by auto [abs]
  ... = α * abs x + β * abs
end --Needs more than 2000 tokens!

--OUTPUT 3
theorem begin
  assume (x y : ℝ) (α β : ℝ) (h1 : α ≥ 0) (h2 : β ≥ 0) (h3 : α + β = 1),
  have h4 : abs (α*x + β*y) ≤ abs (α*x) + abs (β*y), from by auto [abs_add],
  have h5 : abs (α*x + β*y) ≤ α*abs x + β*abs y, from by auto [abs_mul],
  show abs (α*x + β*y) ≤ α*abs x + β*abs y, from by auto [h4, h5],
end

--OUTPUT 4
theorem begin
  assume (x y : ℝ) (α β : ℝ) (h1 : α ≥ 0) (h2 : β ≥ 0) (h3 : α + β = 1),

  calc abs (α*x + β*y) = abs (α*x) + abs (β*y) : by auto [abs_add]
  ... ≤ abs α * abs x + abs β * abs y : by auto [abs_add, abs_mul, abs_nonneg, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [abs_mul, abs_nonneg]
  ... = α * abs x + β * abs y : by auto [
end --Needs more than 2000 tokens!

--OUTPUT 5
theorem begin
  assume x y : ℝ,
  assume α β : ℝ,
  assume h1 : α ≥ 0,
  assume h2 : β ≥ 0,
  assume h3 : α + β = 1,
  calc abs (α * x + β * y) = abs (α * x) + abs (β * y) : by auto [abs_of_nonneg] using [h1, h2]
  ... = α * abs x + β * abs y : by auto [abs_mul]
  ... = α * abs x + β * abs y : by auto [abs]
end

--OUTPUT 6
theorem begin
  assume (x y : ℝ) (α β : ℝ) (h1 : α ≥ 0) (h2 : β ≥ 0) (h3 : α + β = 1),
  have h4 : abs (α*x + β*y) = abs (α*x) + abs (β*y), from by auto [abs_add, abs_mul],
  have h5 : abs (α*x) + abs (β*y) ≤ abs α * abs x + abs β * abs y, from by auto [abs_add, abs_mul],
  have h6 : abs α * abs x + abs β * abs y = α * abs x + β * abs y, from by auto [abs_mul],
  have h7 : α * abs x + β * abs y = α * abs x + β * abs y, from by auto [abs],
  show abs (α*x + β*y) ≤ α * abs x + β * abs y, from by auto [h4, h5, h6, h7],
end

